/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

#ifdef GL_ES
//precision highp float;
precision mediump float;
#endif 

// uniform float time;
// varying vec2 surfacePosition;
 
#define pi    3.1415926535897932384626433832795 //pi
void main( void ) {

	gl_FragColor = vec4(vec3(1.0/(pow(length(sin(vec2((atan(surfacePosition.y,surfacePosition.x)*8.0+time*pi+pi),((1./length(surfacePosition))+time*pi+pi))))+1.0,2.0))), 1.0 );
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15
}